clear all
set more off
capture log close

tsset id t


**appendix table 1
*AUD USD exchange rate 31 2007: 0.84
gen child_d=(children>0)
gen child_d6
gen hhincome_usd=hhincome*0.84
replace income_20=(hhincome_usd<20)
replace income_2050=(hhincome_usd>20&hhincome_usd<50)
replace income_100=(hhincome_usd>100)
gen usd_expenditure=expenditure*0.84

sum usd_expenditure  if year==2008
sum usd_expenditure  if year==2008&expenditure>0

sum id income_20 income_2050 income_100 hhsize child_d if year==2008



***appendix table 2

*column 1 dependent variable is total spending
xtreg exp L(-1/3).paid   weekly_d*  ,fe robust
lincom paid+L.paid+L2.paid+L3.paid
test paid=L.paid=L2.paid=L3.paid=F.paid=0
*column 2 dependent variable is dollar spent as percent of average spending in q12008
sum exp if t<13
replace scaled=(expenditure/117.76)*100


xtreg scaled L(-1/3).paid   weekly_d*  ,fe robust
lincom (paid+L.paid+L2.paid+L3.paid)/4

*column 3 dollars spent on average receipt/100
gen receiptav=paid*900/100

xtreg exp L(-1/3).receiptav   weekly_d*  ,fe robust
lincom receiptav+L.receiptav+L2.receiptav+L3.receiptav

*******appendix table 3
*income percentiles
egen tenth=pct(hhincome), pct(10)
gen paid_bottom20=paid*bottom20

gen paid_10=paid*tenth_d
gen paid_20=paid*twenty_d
gen paid_homeowner=paid*homeowner

****column 1 dependent variable is total spending
xtreg exp L(-1/3).(paid paid_age_d10 paid_10 paid_20 paid_home)  weekly_d*  ,fe robust

*homeowners 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid+ paid_age_d10+L.paid_age_d10+L2.paid_age_d10+L3.paid_age_d10 + paid_20+L.paid_20+L2.paid_20+L3.paid_20 +paid_home+L.paid_home+L2.paid_home+L3.paid_home)

*renters 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid+ paid_age_d10+L.paid_age_d10+L2.paid_age_d10+L3.paid_age_d10 + paid_20+L.paid_20+L2.paid_20+L3.paid_20)

*homeowners 2nd to 10th decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid +paid_home+L.paid_home+L2.paid_home+L3.paid_home)

*renters 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid )

 
*******column 2 dependent variable is dollar spent as percent of average spending in q12008

xtreg scaled L(-1/3).(paid  paid_20 paid_age_d10 paid_home  paid_10  )  weekly_d*  ,fe robust

*homeowners 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid+ paid_age_d10+L.paid_age_d10+L2.paid_age_d10+L3.paid_age_d10 + paid_20+L.paid_20+L2.paid_20+L3.paid_20 +paid_home+L.paid_home+L2.paid_home+L3.paid_home)/4

*renters 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid+ paid_age_d10+L.paid_age_d10+L2.paid_age_d10+L3.paid_age_d10 + paid_20+L.paid_20+L2.paid_20+L3.paid_20)/4

*homeowners 2nd to 10th decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid +paid_home+L.paid_home+L2.paid_home+L3.paid_home)/4

*renters 1st decile of income and age distribution
lincom (paid+L.paid+L2.paid+L3.paid )/4

 

********column 3 dollars spent on average receipt/100
gen receiptav=paid*900/100
gen receiptav_paid_10=receiptav*paid_10
gen receiptav_paid_20=receiptav*paid_20
gen receiptav_home=receiptav*homeowner

xtreg exp L(-1/3).(receiptav  receiptav_paid_20 receiptav_age_d10 receiptav_home receiptav_paid_10)   weekly_d*  ,fe robust

*homeowners 1st decile of income and age distribution
lincom (receiptav+L.receiptav+L2.receiptav+L3.receiptav+ receiptav_age_d10+L.receiptav_age_d10+L2.receiptav_age_d10+L3.receiptav_age_d10 + receiptav_paid_20+L.receiptav_paid_20+L2.receiptav_paid_20+L3.receiptav_paid_20 +receiptav_home+L.receiptav_home+L2.receiptav_home+L3.receiptav_home)

*renters 1st decile of income and age distribution
lincom (receiptav+L.receiptav+L2.receiptav+L3.receiptav+ receiptav_age_d10+L.receiptav_age_d10+L2.receiptav_age_d10+L3.receiptav_age_d10 + receiptav_paid_20+L.receiptav_paid_20+L2.receiptav_paid_20+L3.receiptav_paid_20)

*homeowners 2nd to 10th decile of income and age distribution
lincom (receiptav+L.receiptav+L2.receiptav+L3.receiptav +receiptav_home+L.receiptav_home+L2.receiptav_home+L3.receiptav_home)

*renters 1st decile of income and age distribution
lincom (receiptav+L.receiptav+L2.receiptav+L3.receiptav )


